use clap::Parser;
use rand::Rng;

fn arithmetic(b: &plnk::Bencher) {
    let res = b.bench_multiple_and_return(vec![
        (
            plnk::label! { operation: "addition" }.to_string(),
            plnk::closure! {
                let a = rand::thread_rng().gen::<u128>();
                let b = rand::thread_rng().gen::<u128>();
                plnk::timeit(|| a + b)
            },
        )
            .into(),
        (
            plnk::label! { operation: "subtraction" }.to_string(),
            plnk::closure! {
                let a = rand::thread_rng().gen::<u128>();
                let b = rand::thread_rng().gen::<u128>();
                plnk::timeit(|| a - b)
            },
        )
            .into(),
        (
            plnk::label! { operation: "multiplication" }.to_string(),
            plnk::closure! {
                let a = rand::thread_rng().gen::<u128>();
                let b = rand::thread_rng().gen::<u128>();
                plnk::timeit(|| a * b)
            },
        )
            .into(),
    ]);

    eprintln!("last value: {}", res.unwrap());
}

fn random(b: &plnk::Bencher) {
    b.bench(
        plnk::label! { operation: "sampling" },
        plnk::closure! { plnk::timeit(|| rand::thread_rng().gen::<u128>()) },
    );
}

#[derive(Parser, Debug)]
struct Args {
    #[arg(short, long, default_value_t = 10)]
    nb_measurements: usize,

    #[arg(short, long)]
    log_file: Option<String>,
}

fn main() {
    let args = Args::parse();

    let bencher = match args.log_file {
        Some(path) => plnk::Bencher::new(args.nb_measurements)
            .with_file(path.into())
            .overwrite(),
        None => plnk::Bencher::new(args.nb_measurements),
    };

    arithmetic(&bencher.with_name("arithmetic"));
    random(&bencher.with_name("random").append());
}
